/* Copyright (C) 2017-2018 RealVNC Ltd.  All Rights Reserved.
 */

#ifndef VCDFCL_H_335545204994277943022069012253731107696
#define VCDFCL_H_335545204994277943022069012253731107696

#include <vncrenderer.h>
#include <cdfdecoder/vnccommondecoder.h>

/**
 * \file vcdfcl.h
 *
 * This is the header file for the Viewer SDK/Common Decoder Framework
 * Compatibility Layer.
 */

/**
 * \mainpage Viewer SDK/Common Decoder Framework Compatibility Layer
 *
 * \section section_overview Overview
 *
 * The V/CDFCL allows Common Decoder Framework Decoder Plugins to be loaded
 * as Pluggable Decoders and Renderers.
 *
 * To use it, load the V/CDFCL as a pluggable renderer, setting the
 * VNCRendererViewerContext to point to an instance of the VCDFCLInitDetails
 * struct.
 *
 * \section section_legal Legal information
 *
 * Copyright &copy; 2017-2018 RealVNC Ltd.  All Rights Reserved.
 *
 * RealVNC and VNC are trademarks of RealVNC Limited and are protected by
 * trademark registrations and/or pending trademark applications in the
 * European Union, United States of America and other jurisdictions.
 *
 * Other trademarks are the property of their respective owners.
 *
 * Protected by UK patents 2481870, 2491657; US patents 8760366, 9137657; EU patent 2652951.
 *
 */

typedef struct
{
    /**
     * \brief The directory in which the decoder shared library resides.
     *
     * If this is NULL, then the default system library search path will be
     * used. An empty string value, or ".", will use the current working
     * directory.
     */
    const char* decoderDirectory;

    /**
     * \brief The name of the decoder to load.
     *
     * The shared library filename must be in the following format:
     *
     *   On Linux:    'libvnccommondecoder-NAME.so'
     *   On macOS:    'libvnccommondecoder-NAME.dylib'
     *   On Windows:  'vnccommondecoder-NAME.dll'
     *
     * To load the decoder with the above filename, this field should
     * be set to the string "NAME".
     */
    const char* decoderName;

} VCDFCLLoadPluginFromLibraryDetails;


typedef struct
{
    /**
     * \brief The entry point of the decoder plugin to be registered.
     */
    VNCCommonDecoderInitializeType* entryPoint;

} VCDFCLLoadPluginFromPointerDetails;


typedef struct
{
    /**
     * \brief To allow for backwards compatibility, this field must be set to
     * sizeof(VCDFCLInitDetails). The V/CDFCL will only attempt to access
     * fields within this size bound.
     */
    size_t structSize;

    /**
     * \brief If this is not null, this instructs the V/CDFCL to load a Common
     * Decoder Framework Decoder Plugin from a shared library.
     *
     * It should point to an instance of the VCDFCLLoadPluginFromLibraryDetails
     * struct, filled in with the necessary details. This struct should be
     * valid until the "register renderer" call is completed.
     *
     * If this property is set, then loadFromPointerDetails should be NULL.
     *
     * The error code returned by the "register renderer" operation shall
     * indicate whether or not the load was successful. VNCRendererErrorNone
     * indicates that the load was successful, and any other error code
     * indicates that it was not.
     */
    const VCDFCLLoadPluginFromLibraryDetails* loadFromLibraryDetails;

    /**
     * \brief If this is not null, this instructs the V/CDFCL to load a Common
     * Decoder Framework Decoder Plugin from a function pointer.
     *
     * It should point to an instance of the VCDFCLLoadPluginFromPointerDetails
     * struct, filled in with the necessary details. This struct should be
     * valid until the "register renderer" call is completed.
     *
     * If this property is set, then loadFromLibraryDetails should be NULL.
     *
     * The error code returned by the "register renderer" operation shall
     * indicate whether or not the load was successful. VNCRendererErrorNone
     * indicates that the load was successful, and any other error code
     * indicates that it was not.
     */
    const VCDFCLLoadPluginFromPointerDetails* loadFromPointerDetails;

    /**
     * \brief The context pointer to be passed unaltered to
     * VNCCommonDecoderInitialize.
     */
    VNCCommonDecoderApplicationContext cdfApplicationContext;

    /**
     * \brief When a rectangle is received, the V/CDFCL will immediately
     * provide the rectangle to the CDF decoder plugin as a payload, and will
     * then block the Viewer SDK thread until the number of in-flight payloads
     * is less than or equal to this value.
     *
     * Payloads are "in flight" when they have been provided to the CDF decoder
     * plugin, and have not yet been recycled.
     *
     * Any value greater than or equal to zero may be chosen. The recommended
     * value is "1".
     *
     * Setting this value to "0" will cause the Viewer SDK to always wait until
     * each payload has been recycled before continuing with the connection.
     * This may have performance implications depending on the CDF decoder
     * plugin in use.
     *
     * Increasing this value may increase the latency of the connection, but
     * may improve the framerate in some cases.
     */
    vnc_uint32_t maxInFlightPayloads;

} VCDFCLInitDetails;


#endif // VCDFCL_H_335545204994277943022069012253731107696

